//
//  CRPhotoView.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 04/04/10
//  Copyright 2009 Corner-A. All rights reserved.
//

#import "CRPhotoViewBase.h"
#import "CRInplaceEditorController.h"

//////////////////////////////////////////////////////////////////////
// Complex PhotoView visual object, render the image, provides data
// and notifications for image editors
//////////////////////////////////////////////////////////////////////
@interface CRPhotoView : CRPhotoViewBase
{
@private
	BOOL								extraSize;
	id<CRPhotoViewImageSourceProtocol>	imageSource;
}

@property (nonatomic, assign) id<CRPhotoViewImageSourceProtocol> imageSource;

- (NSRect)fullArea;
- (NSRect)sheetExtent;

- (void)updateView;
- (void)disconnect;

@end